"use client"

import { ClientDataWrapper } from "@/components/client.data-wrapper"
import { LoadingDialog } from "@/components/loading.dialog"
import { useGetAgencies } from "@/hooks/use-get-agencies"
import { WorkflowDialog } from "./workflow.dialog"

export function WorkflowDialogClient() {
  const res = useGetAgencies()
  return (
    <ClientDataWrapper
      swr={res}
      overrides={{
        loading: <LoadingDialog />,
      }}
      content={(data) => (
        <WorkflowDialog data={data} />
      )}
    />
  )
}
